/******************************************************************************
*                                                  
*  (c) copyright Freescale Semiconductor 2008
*  ALL RIGHTS RESERVED
*
*  File Name: Bootloader.h
*                                                                          
*  Purpose: This file is for a USB Mass-Storage Device bootloader.  This file 
*           has the structures and definitions for the bootloader
*                                                                          
*  Assembler:  Codewarrior for Microcontrollers V6.2
*                                            
*  Version:  1.2
*                                                                          
*                                                                          
*  Author: Derek Snell                             
*                                                                                       
*  Location: Indianapolis, IN. USA                                            
*                                                                                  
* UPDATED HISTORY:
*
* REV   YYYY.MM.DD  AUTHOR        DESCRIPTION OF CHANGE
* ---   ----------  ------        --------------------- 
* 1.2   2009.01.13  Derek Snell   Added defines for cores to differentiate in ParseS19.c
* 1.1   2008.09.17  Derek Snell   Added ReEnumeration fields
* 1.0   2008.06.10  Derek Snell   Initial version
* 
*
******************************************************************************/                                                                        
/* Freescale  is  not  obligated  to  provide  any  support, upgrades or new */
/* releases  of  the Software. Freescale may make changes to the Software at */
/* any time, without any obligation to notify or provide updated versions of */
/* the  Software  to you. Freescale expressly disclaims any warranty for the */
/* Software.  The  Software is provided as is, without warranty of any kind, */
/* either  express  or  implied,  including, without limitation, the implied */
/* warranties  of  merchantability,  fitness  for  a  particular purpose, or */
/* non-infringement.  You  assume  the entire risk arising out of the use or */
/* performance of the Software, or any systems you design using the software */
/* (if  any).  Nothing  may  be construed as a warranty or representation by */
/* Freescale  that  the  Software  or  any derivative work developed with or */
/* incorporating  the  Software  will  be  free  from  infringement  of  the */
/* intellectual property rights of third parties. In no event will Freescale */
/* be  liable,  whether in contract, tort, or otherwise, for any incidental, */
/* special,  indirect, consequential or punitive damages, including, but not */
/* limited  to,  damages  for  any loss of use, loss of time, inconvenience, */
/* commercial loss, or lost profits, savings, or revenues to the full extent */
/* such  may be disclaimed by law. The Software is not fault tolerant and is */
/* not  designed,  manufactured  or  intended by Freescale for incorporation */
/* into  products intended for use or resale in on-line control equipment in */
/* hazardous, dangerous to life or potentially life-threatening environments */
/* requiring  fail-safe  performance,  such  as  in the operation of nuclear */
/* facilities,  aircraft  navigation  or  communication systems, air traffic */
/* control,  direct  life  support machines or weapons systems, in which the */
/* failure  of  products  could  lead  directly to death, personal injury or */
/* severe  physical  or  environmental  damage  (High  Risk Activities). You */
/* specifically  represent and warrant that you will not use the Software or */
/* any  derivative  work of the Software for High Risk Activities.           */
/* Freescale  and the Freescale logos are registered trademarks of Freescale */
/* Semiconductor Inc.                                                        */ 
/*****************************************************************************/

#include "derivative.h"

#ifdef  _MCF51JM128_H
    #define CF_CORE
    #define V1_CORE
    #define MIN_RAM1_ADDRESS        0x800000
    #define MAX_RAM1_ADDRESS        0x803FFF
    #define MIN_FLASH1_ADDRESS      0x000000
    #define MAX_FLASH1_ADDRESS      0x01FFFF
    #define FLASH_PROTECTED_ADDRESS 0x001FFF
    #define USER_ENTRY_ADDRESS      0x0021C0
    #define REDIRECT_VECTORS        0x002000
       
    #define FLASH_PAGE_SIZE     1024
    
    // RAM locations for USB Buffers
    #define USB_BUFFER_START        0x00800200
    #define MSD_BUFFER_SIZE         512
    #define USB_BDT_START           (USB_BUFFER_START + 2*MSD_BUFFER_SIZE)
    #define BDT_SIZE                16
    #define ICP_BUFFER_SIZE         64

    void _Entry(void) ;
#endif

// Bootloader Status
#define BootloaderReady       0
#define BootloaderS19Error    1
#define BootloaderFlashError  2
#define BootloaderSuccess     3
#define BootloaderStarted     4

// ReEnumeration Status
#define NO                    0
#define YES                   1
#define DONE                  2

#define TRUE  1
#define FALSE 0

#ifndef USB_HANDLE_H
#define USB_HANDLE_H

// USB command
#define mGET_STATUS           0
#define mCLR_FEATURE          1
#define mSET_FEATURE          3
#define mSET_ADDR             5
#define mGET_DESC             6
#define mSET_DESC             7
#define mGET_CONFIG           8
#define mSET_CFG              9
#define mGET_INTF             10
#define mSET_INTF             11
#define mSYNC_FRAME           12
#define	mGET_MAXLUN	          0xFE		// Mass Storage command

// Descriptor Types
#define mDESC_DEV     0x01
#define mDESC_CFG     0x02
#define mDESC_STR     0x03

// Endpoint0 Token define
#define mEP0_OUT      0x00
#define mEP0_IN       0x08
#define mEP1_IN       0x18
#define mEP2_OUT      0x20
#define mSETUP_TOKEN  0b00001101


#define mMCU      0x00
#define mUDATA0   0x88
#define mUDATA1   0xC8

#define mEP0_BUFF_SIZE  64
#define cEP1_BUFF_SIZE  64
#define cEP2_BUFF_SIZE  64

#define gFlashSuccess  0x01
#define gFlashError    0xFF

#define STALL_EP2     (ENDPT2 |= ENDPT2_EP_STALL_MASK)




// USB state machine
enum _USB_States
{
	cDETACH,
	cATTACH,
	cPOWER,
	cDEFAULT,
  cADR_PENDING,
  cADDRESS,
  cCONFIGURE,
  cSUSPEND
};

  // Control transfer state machine
enum _USBCTL_States
{
  cCBW,                 
  cCSW,
  cEP1Tx,
  cEP2Rx,
  mICP_WAIT,     
  mICP_TX,       
  mICP_RX       
};



typedef union _tBDT_STAT
{
    byte _byte;
    struct{
        byte  :2;                    // bit 0-1 reserved
        byte BSTALL:1;              // BDT stall'
        byte DTS:1;                 //Data Toggle Synch Enable
        byte NINC:1;                //Address Increment Disable
        byte KEEP:1;                //BD Keep Enable
        byte DATA:1;                //Data Toggle Synch Value
        byte UOWN:1;                //USB Ownership   
    }CtlBit;
    
  
    struct{
        byte    :2;
        byte PID:4;                 //Packet Identifier
        byte    :2;
        
    }RecPid;
} tBDT_STAT;                            //Buffer Descriptor Status Register

typedef struct _tBDT
{
  tBDT_STAT BDT_Stat;
  byte      Rev;
  byte      Cnt;
  byte      Rev2;
  byte      Addr0;
  byte      Addr1;
  byte      Addr2;
  byte      Addr3;
}tBDT;


typedef struct _tUSB_Setup {
       byte bmRequestType;
       byte bRequest;
       byte wValue_l;
       byte wValue_h;
       byte wIndex_l;
       byte wIndex_h;
       byte wLength_l;
       byte wLength_h;
}tUSB_Setup;

typedef struct _tICPSTR
{
  byte Byte;
  struct {
    byte AddrPend     :1;                                      
    byte none         :1;                                       
    byte Prog         :1;                                       
    byte Verify       :1;                                      
    byte none2        :1;                                       
    byte none3        :1;
    byte none4        :1;
    byte none5        :1;                                      
  } Bits;
}tICPSTR;

#endif USB_HANDLE_H


